<?php
// Función para escribir datos en un archivo CSV
function escribirCSV($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code) {
    $archivo = 'registros.csv';
    $fechaRegistro = date('Y-m-d H:i:s');
    $datos = array($fechaRegistro, $name, $lastname, $rut, "+56 9 $phone", $email, $birthdate, $address, $region, $subscription, $discount_code);
    $manejador = fopen($archivo, 'a');
    fputcsv($manejador, $datos);
    fclose($manejador);
}

// Función para escribir datos en un archivo TXT
function escribirTXT($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code) {
    $archivo = 'registros.txt';
    $fechaRegistro = date('Y-m-d H:i:s');
    $contenido = "Registro realizado el: $fechaRegistro\n";
    $contenido .= "Nombre(s): $name\n";
    $contenido .= "Apellidos: $lastname\n";
    $contenido .= "RUT: $rut\n";
    $contenido .= "Teléfono: +56 9 $phone\n";
    $contenido .= "Correo Electrónico: $email\n";
    $contenido .= "Dirección: $address\n";
    $contenido .= "Región: $region\n";
    $contenido .= "Plan Online Gamma $subscription\n";
    $contenido .= "Código de descuento utilizado: $discount_code\n";
    $contenido .= "--------------------------\n";
    file_put_contents($archivo, $contenido, FILE_APPEND);
}

// Función para verificar si el código de descuento es válido
function verificarCodigoDescuento($codigo) {
    $archivo = 'codigos_descuento.txt';
    if (!file_exists($archivo)) {
        return false; // Si no existe el archivo, no hay códigos válidos
    }

    $codigosValidos = file($archivo, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return in_array($codigo, $codigosValidos);
}

// Envío de correo electrónico
function enviarCorreo($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code) {
    $correo_remitente = "admision@mauroquintana.cl";
    $nombre_remitente = "CEM Mauro Quintana";
    $destinatario = "admision@mauroquintana.cl";
    $asunto = "Nueva venta SubeNotas $subscription";

    $mensaje = "Se ha recibido un nuevo pedido:\n\n";
    $mensaje .= "Nombre(s): $name\n";
    $mensaje .= "Apellidos: $lastname\n";
    $mensaje .= "RUT: $rut\n";
    $mensaje .= "Teléfono: +56 9 $phone\n";
    $mensaje .= "Correo Electrónico: $email\n";
    $mensaje .= "Fecha de nacimiento: $birthdate\n";
    $mensaje .= "Dirección: $address\n";
    $mensaje .= "Región: $region\n";
    $mensaje .= "Plan Online SubeNotas $subscription\n";
    $mensaje .= "Código de descuento utilizado: $discount_code\n";

    $headers = "From: " . $nombre_remitente . " <" . $correo_remitente . ">\r\n";
    $headers .= "Reply-To: " . $correo_remitente . "\r\n";
    $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
    $headers .= "MIME-Version: 1.0\r\n";

    if (!mail($destinatario, $asunto, $mensaje, $headers)) {
        echo json_encode([
            'error' => 'Hubo un error al enviar el correo.'
        ]);
        exit();
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = htmlspecialchars($_POST['name']);
    $lastname = htmlspecialchars($_POST['lastname']);
    $rut = htmlspecialchars($_POST['rut']);
    $phone = htmlspecialchars($_POST['phone']);
    $email = htmlspecialchars($_POST['email']);
    $birthdate = htmlspecialchars($_POST['birthdate']);
    $address = htmlspecialchars($_POST['address']);
    $region = htmlspecialchars($_POST['region']);
    $subscription = htmlspecialchars($_POST['subscription']);
    $has_discount = htmlspecialchars($_POST['has_discount']);

    // Validación del código de descuento
    $discount_code = '';
    if ($has_discount === 'si') {
        $discount_code = htmlspecialchars($_POST['discount_code']);
        if (empty($discount_code) || !verificarCodigoDescuento($discount_code)) {
            echo json_encode([
                'error' => 'El código de descuento ingresado no es válido o está vacío.'
            ]);
            exit();
        }
    }

    // Validación de campos requeridos
    if (empty($name) || empty($lastname) || empty($rut) || empty($phone) || empty($email) || empty($birthdate) || empty($address) || empty($region) || empty($subscription)) {
        echo json_encode([
            'error' => 'Por favor, completa todos los campos requeridos.'
        ]);
        exit();
    }

    // Escritura en archivos
    escribirCSV($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code);
    escribirTXT($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code);

    // Envío de correo electrónico
    enviarCorreo($name, $lastname, $rut, $phone, $email, $birthdate, $address, $region, $subscription, $discount_code);

    // Responde con JSON en lugar de redirigir
    echo json_encode([
        'redirect_url' => ($subscription === 'semestral')
            ? ($has_discount === 'si' ? 'https://pagos.mauroquintana.cl/SubeNotas/Anual/Cod/' : 'https://pagos.mauroquintana.cl/SubeNotas/Anual/')
            : ($has_discount === 'si' ? 'https://pagos.mauroquintana.cl/SubeNotas/Anual/Cod/' : 'https://pagos.mauroquintana.cl/SubeNotas/Anual/')
    ]);
    exit();
}
?>
