<?php
// Función para escribir datos en un archivo CSV
function escribirCSV($nombre, $rut, $telefono, $email, $direccion, $monto, $codigo_descuento, $metodo_pago) {
    $archivo = 'datos_formulario.csv';
    $datos = array($nombre, $rut, $telefono, $email, $direccion, $monto, $codigo_descuento, $metodo_pago);
    $manejador = fopen($archivo, 'a');
    fputcsv($manejador, $datos);
    fclose($manejador);
}

// Función para obtener el número de pedidos
function obtenerNumeroPedidos() {
    $archivo_contador = 'contador_pedidos.txt';
    if (file_exists($archivo_contador)) {
        $contador = intval(file_get_contents($archivo_contador));
    } else {
        $contador = 0;
    }
    return $contador;
}

// Función para incrementar el contador de pedidos
function incrementarContadorPedidos() {
    $archivo_contador = 'contador_pedidos.txt';
    $contador = obtenerNumeroPedidos() + 1;
    if (!file_exists('contador')) {
        mkdir('contador', 0777, true); // Crear la carpeta si no existe
    }
    file_put_contents($archivo_contador, $contador);
}

// Función para formatear el número de teléfono
function formatearTelefono($telefono) {
    // Eliminar todos los espacios en blanco
    $telefono = preg_replace('/\s+/', '', $telefono);

    // Verificar si el número ya comienza con +56 9
    if (substr($telefono, 0, 4) !== '+569') {
        // Agregar el prefijo +56 9 si no está presente
        $telefono = '+569' . $telefono;
    }

    // Asegurarse de que el número tenga el formato correcto
    $telefono = substr($telefono, 0, 4) . ' ' . substr($telefono, 4, 4) . ' ' . substr($telefono, 8);

    return $telefono;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = utf8_decode($_POST['nombre']);
    $email = $_POST['email'];
    $direccion = $_POST['direccion'];
    $rut = $_POST['rut'];
    $telefono = formatearTelefono($_POST['telefono']);
    $tieneDescuento = $_POST['tiene_descuento'];
    $codigo_descuento = isset($_POST['codigo_descuento']) ? $_POST['codigo_descuento'] : '';

    // Dirección de correo fija como remitente
    $correo_remitente = "tienda@mauroquintana.cl";
    $nombre_remitente = "CEM Mauro Quintana";
    
    // Dirección de correo fija como replicar
    $correo_responder = "admision@mauroquintana.cl";
    $nombre_responder = "Admisión CEM";
    
    // Dirección de correo a la que se enviarán los datos
    $destinatario = "admision@mauroquintana.cl";

    // Asunto del correo
    $asunto = "Alpha Semestral - Nuevo pago recibido";

    // Determinar el monto y método de pago
    if ($tieneDescuento === 'si') {
        $monto = 436891;
        $mensaje_descuento = "Código de descuento: " . $codigo_descuento . "\n";
    } else {
        $monto = 459885;
        $mensaje_descuento = "";
    }

    if (isset($_POST['btn_transferencia_bancaria'])) {
        $metodo_pago = "Transferencia Bancaria";
    } elseif (isset($_POST['btn_webpay'])) {
        $metodo_pago = "WebPay";
    }

    // Cuerpo del correo
    $mensaje = "Se ha recibido un nuevo pago:\n\n";
    $mensaje .= "Nombre: " . $nombre . "\n";
    $mensaje .= "Correo electrónico: " . $email . "\n";
    $mensaje .= "Dirección: " . $direccion . "\n";
    $mensaje .= "RUT: " . $rut . "\n";
    $mensaje .= "Teléfono: " . $telefono . "\n";
    $mensaje .= "Monto: $ " . number_format($monto, 0, ',', '.') . "\n";
    $mensaje .= $mensaje_descuento;
    $mensaje .= "Método de pago: " . $metodo_pago . "\n";

    // Cabeceras adicionales
    $headers = "From: " . $nombre_remitente . " <" . $correo_remitente . ">\r\n";
    $headers .= "Reply-To: " . $nombre_responder . " <" . $correo_responder . ">\r\n";
    $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
    $headers .= "MIME-Version: 1.0\r\n";

    // Enviar el correo
    mail($destinatario, $asunto, $mensaje, $headers);

    // Escribir datos en el archivo CSV
    escribirCSV($nombre, $rut, $telefono, $email, $direccion, $monto, $codigo_descuento, $metodo_pago);

    // Incrementar el contador de pedidos
    incrementarContadorPedidos();

    // Redirigir según el método de pago y el descuento
    if ($metodo_pago === "Transferencia Bancaria") {
        if ($tieneDescuento === 'si') {
            header("Location: https://pagos.mauroquintana.cl/AS/CodTB");
        } else {
            header("Location: https://pagos.mauroquintana.cl/AS/TB");
        }
    } elseif ($metodo_pago === "WebPay") {
        if ($tieneDescuento === 'si') {
            header("Location: https://pagos.mauroquintana.cl/AS5");
        } else {
            header("Location: https://pagos.mauroquintana.cl/AlphaSemestral");
        }
    }
    exit;
}

// Obtener el número de pedidos
$numero_pedidos = obtenerNumeroPedidos();
?>
