<?php
// Función para escribir datos en un archivo CSV
function escribirCSV($nombre, $rut, $telefono, $email, $direccion, $monto, $codigo_descuento) {
    $archivo = 'datos_formulario.csv';
    $datos = array($nombre, $rut, $telefono, $email, $direccion, $monto, $codigo_descuento);
    $manejador = fopen($archivo, 'a');
    fputcsv($manejador, $datos);
    fclose($manejador);
}

// Función para obtener el número de pedidos
function obtenerNumeroPedidos() {
    $archivo_contador = 'contador_pedidos.txt';
    if (file_exists($archivo_contador)) {
        $contador = intval(file_get_contents($archivo_contador));
    } else {
        $contador = 0;
    }
    return $contador;
}

// Función para incrementar el contador de pedidos
function incrementarContadorPedidos() {
    $archivo_contador = 'contador_pedidos.txt';
    $contador = obtenerNumeroPedidos() + 1;
    file_put_contents($archivo_contador, $contador);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = utf8_decode($_POST['nombre']);
    $email = $_POST['email'];
    $direccion = $_POST['direccion'];
    $rut = $_POST['rut'];
    $telefono = $_POST['telefono'];
    $tieneDescuento = $_POST['tiene_descuento'];
    $codigo_descuento = isset($_POST['codigo_descuento']) ? $_POST['codigo_descuento'] : '';

    // Dirección de correo fija como remitente
    $correo_remitente = "tienda@mauroquintana.cl";
    $nombre_remitente = "CEM Mauro Quintana";
    
    // Dirección de correo fija como replicar
    $correo_responder = "admision@mauroquintana.cl";
    $nombre_responder = "Admisión CEM";
    
    // Dirección de correo a la que se enviarán los datos
    $destinatario = "admision@mauroquintana.cl";

    // Asunto del correo
    $asunto = "Nuevo pago recibido";

    // Cuerpo del correo
    $mensaje = "Se ha recibido un nuevo pago:\n\n";
    $mensaje .= "Nombre: " . $nombre . "\n";
    $mensaje .= "Correo electrónico: " . $email . "\n";
    $mensaje .= "Dirección: " . $direccion . "\n";
    $mensaje .= "RUT: " . $rut . "\n";
    $mensaje .= "Teléfono: " . $telefono . "\n";
    if ($tieneDescuento === 'si') {
        $mensaje .= "Monto: $55000\n";
        $mensaje .= "Código de descuento: " . $codigo_descuento . "\n";
        $monto = 55000;
    } else {
        $mensaje .= "Monto: $60000\n";
        $monto = 60000;
    }

    // Cabeceras adicionales
    $headers = "From: " . $nombre_remitente . " <" . $correo_remitente . ">\r\n";
    $headers .= "Reply-To: " . $nombre_responder . " <" . $correo_responder . ">\r\n";
    $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
    $headers .= "MIME-Version: 1.0\r\n";

    // Enviar el correo
    mail($destinatario, $asunto, $mensaje, $headers);

    // Escribir datos en el archivo CSV
    escribirCSV($nombre, $rut, $telefono, $email, $direccion, $monto, $codigo_descuento);

    // Incrementar el contador de pedidos
    incrementarContadorPedidos();

    // Redirigir según el método de pago y el descuento
    if (isset($_POST['btn_transferencia_bancaria'])) {
        if ($tieneDescuento === 'si') {
            header("Location: https://pagos.mauroquintana.cl/60x60CodTB");
        } else {
            header("Location: https://pagos.mauroquintana.cl/60x60TB");
        }
    } elseif (isset($_POST['btn_webpay'])) {
        if ($tieneDescuento === 'si') {
            header("Location: https://pagos.mauroquintana.cl/60x60Cod");
        } else {
            header("Location: https://pagos.mauroquintana.cl/60x60Invierno");
        }
    }
    exit;
}

// Obtener el número de pedidos
$numero_pedidos = obtenerNumeroPedidos();
?>
